/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.http;

import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndContainer;
import jade.core.FrontEnd;
import jade.core.IMTPException;
import jade.core.ProfileException;
import jade.core.Runtime;
import jade.core.Timer;
import jade.core.TimerListener;
import jade.imtp.leap.BackEndSkel;
import jade.imtp.leap.Dispatcher;
import jade.imtp.leap.FrontEndStub;
import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.JICPMediator;
import jade.imtp.leap.JICP.JICPMediatorManager;
import jade.imtp.leap.JICP.JICPPacket;
import jade.imtp.leap.MicroSkeleton;
import jade.util.Logger;
import jade.util.leap.Properties;
import java.net.InetAddress;

public class HTTPBEDispatcher
implements BEConnectionManager,
Dispatcher,
JICPMediator {
    private JICPMediatorManager myMediatorManager;
    private String myID;
    private MicroSkeleton mySkel = null;
    private FrontEndStub myStub = null;
    private BackEndContainer myContainer = null;
    private OutgoingsHandler myOutgoingsHandler;
    private InetAddress lastRspAddr;
    private int lastRspPort;
    private JICPPacket lastResponse = null;
    private byte lastSid = (byte)16;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());

    public String getID() {
        return this.myID;
    }

    public void init(JICPMediatorManager mgr, String id, Properties props) throws ICPException {
        this.myMediatorManager = mgr;
        this.myID = id;
        long maxDisconnectionTime = 600000L;
        try {
            maxDisconnectionTime = Long.parseLong(props.getProperty("max-disconnection-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        long keepAliveTime = 60000L;
        try {
            keepAliveTime = Long.parseLong(props.getProperty("keep-alive-time"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.myOutgoingsHandler = new OutgoingsHandler(maxDisconnectionTime, keepAliveTime);
        if (this.myLogger.isLoggable(Logger.INFO)) {
            this.myLogger.log(Logger.INFO, "Created HTTPBEDispatcher V2.0. ID = " + this.myID + "\n- MaxDisconnectionTime = " + maxDisconnectionTime);
        }
        this.myStub = new FrontEndStub(this);
        this.mySkel = this.startBackEndContainer(props);
    }

    protected final BackEndSkel startBackEndContainer(Properties props) throws ICPException {
        try {
            String nodeName = this.myID.replace(':', '_');
            props.setProperty("container-name", nodeName);
            props.setProperty("be-mediator-id", this.myID);
            this.myContainer = new BackEndContainer(props, this);
            if (!this.myContainer.connect()) {
                throw new ICPException("BackEnd container failed to join the platform");
            }
            this.myID = this.myContainer.here().getName();
            if (this.myLogger.isLoggable(Logger.CONFIG)) {
                this.myLogger.log(Logger.CONFIG, "BackEndContainer " + this.myID + " successfully joined the platform.");
            }
            return new BackEndSkel(this.myContainer);
        }
        catch (ProfileException pe) {
            pe.printStackTrace();
            throw new ICPException("Error creating profile");
        }
    }

    public void activateReplica(String addr, Properties props) throws IMTPException {
    }

    public void kill() {
        this.myContainer.shutDown();
    }

    public JICPPacket handleJICPPacket(JICPPacket pkt, InetAddress addr, int port) throws ICPException {
        String from = " [" + addr + ":" + port + "]";
        if (pkt.getType() == 0) {
            if ((pkt.getInfo() & 0x40) != 0) {
                if (this.myLogger.isLoggable(Logger.FINE)) {
                    this.myLogger.log(Logger.FINE, "Peer termination notification received " + from);
                }
                this.handlePeerExited();
                return null;
            }
            byte sid = pkt.getSessionID();
            if (sid == this.lastSid) {
                if (this.myLogger.isLoggable(Logger.INFO)) {
                    this.myLogger.log(Logger.INFO, "Duplicated command received " + sid + " " + from);
                }
                pkt = this.lastResponse;
            } else {
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Incoming command received " + sid + " " + from);
                }
                byte[] rspData = this.mySkel.handleCommand(pkt.getData());
                if (this.myLogger.isLoggable(Logger.FINEST)) {
                    this.myLogger.log(Logger.FINEST, "Incoming command served " + sid);
                }
                pkt = new JICPPacket(1, 0, rspData);
                pkt.setSessionID(sid);
                this.lastSid = sid;
                this.lastResponse = pkt;
            }
            return pkt;
        }
        this.lastRspAddr = addr;
        this.lastRspPort = port;
        return this.myOutgoingsHandler.dispatchResponse(pkt, from);
    }

    public boolean handleIncomingConnection(Connection c, JICPPacket pkt, InetAddress addr, int port) {
        this.myOutgoingsHandler.setConnecting();
        return false;
    }

    private void ensureFERunning(final long timeout) {
        Thread t = new Thread(){

            public void run() {
                if (timeout > 0L && !HTTPBEDispatcher.this.myOutgoingsHandler.waitForInitialResponse(timeout) && HTTPBEDispatcher.this.myLogger.isLoggable(Logger.INFO)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.INFO, "Missing initial dummy response after reconnection");
                }
            }
        };
        t.start();
    }

    public void tick(long currentTime) {
    }

    public synchronized byte[] dispatch(byte[] payload, boolean flush) throws ICPException {
        JICPPacket pkt = new JICPPacket(0, 0, payload);
        if ((pkt = this.myOutgoingsHandler.deliverCommand(pkt, flush)).getType() == 100) {
            throw new ICPException(new String(pkt.getData()));
        }
        return pkt.getData();
    }

    public FrontEnd getFrontEnd(BackEnd be, Properties props) throws IMTPException {
        return this.myStub;
    }

    public void shutdown() {
        if (this.myLogger.isLoggable(Logger.FINE)) {
            this.myLogger.log(Logger.FINE, "Initiate HTTPBEDispatcher shutdown");
        }
        if (this.myID != null) {
            this.myMediatorManager.deregisterMediator(this.myID);
            this.myID = null;
        }
        this.myOutgoingsHandler.setTerminating();
    }

    protected void handlePeerExited() {
        this.myOutgoingsHandler.setTerminating();
        this.kill();
    }

    protected void handleConnectionError() {
        this.myOutgoingsHandler.setTerminating();
        this.kill();
    }

    static /* synthetic */ FrontEndStub access$300(HTTPBEDispatcher x0) {
        return x0.myStub;
    }

    private class OutgoingsHandler
    implements TimerListener {
        private static final int REACHABLE = 0;
        private static final int CONNECTING = 1;
        private static final int UNREACHABLE = 2;
        private static final int TERMINATED = 3;
        private static final long RESPONSE_TIMEOUT = 5000L;
        private static final int MAX_SID = 15;
        private int frontEndStatus = 1;
        private int outCnt = 0;
        private Thread commandWaiter = null;
        private Thread responseWaiter = null;
        private JICPPacket currentCommand = null;
        private JICPPacket currentResponse = null;
        private boolean commandReady = false;
        private boolean responseReady = false;
        private boolean connectionReset = false;
        private long maxDisconnectionTime;
        private long keepAliveTime;
        private Timer disconnectionTimer = null;
        private boolean waitingForFlush = false;
        private Object initialResponseLock = new Object();
        private boolean initialResponseReceived;

        public OutgoingsHandler(long maxDisconnectionTime, long keepAliveTime) {
            this.maxDisconnectionTime = maxDisconnectionTime;
            this.keepAliveTime = keepAliveTime;
        }

        public boolean frontEndUnreachable() {
            return this.frontEndStatus == 2;
        }

        public synchronized JICPPacket deliverCommand(JICPPacket cmd, boolean flush) throws ICPException {
            if (this.frontEndStatus == 0) {
                if (this.waitingForFlush && !flush) {
                    throw new ICPException("Upsetting dispatching order");
                }
                this.waitingForFlush = false;
                int sid = this.outCnt;
                this.outCnt = this.outCnt + 1 & 0xF;
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINEST)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINEST, "Scheduling outgoing command for delivery " + sid);
                }
                cmd.setSessionID((byte)sid);
                this.currentCommand = cmd;
                this.commandReady = true;
                this.notifyAll();
                while (!this.responseReady) {
                    try {
                        this.responseWaiter = Thread.currentThread();
                        this.wait(5000L * (long)(1 + cmd.getLength() / 4096));
                        this.responseWaiter = null;
                        if (this.responseReady) continue;
                        if (this.frontEndStatus == 1) {
                            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                                HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Response will never arrive " + sid);
                            }
                        } else if (this.frontEndStatus != 3) {
                            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                                HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Response timeout expired " + sid);
                            }
                            this.setUnreachable();
                        }
                        --this.outCnt;
                        if (this.outCnt < 0) {
                            this.outCnt = 15;
                        }
                        throw new ICPException("Missing response");
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINEST)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.FINEST, "Expected response arrived " + this.currentResponse.getSessionID());
                }
                this.responseReady = false;
                return this.currentResponse;
            }
            throw new ICPException("Unreachable");
        }

        /*
         * Unable to fully structure code
         */
        public synchronized JICPPacket dispatchResponse(JICPPacket rsp, String from) {
            if ((rsp.getInfo() & 32) != 0) {
                if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.ALL)) {
                    HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.ALL, "Keep-alive response received");
                }
                this.notifyAll();
            } else if (this.responseWaiter != null) {
                if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINEST)) {
                    HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINEST, "Response received " + rsp.getSessionID() + from);
                }
                this.responseReady = true;
                this.currentResponse = rsp;
                this.notifyAll();
            } else if (this.frontEndStatus == 1) {
                if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINE)) {
                    HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINE, "Initial dummy response received " + rsp.getSessionID() + from);
                }
                this.notifyInitialResponseReceived();
            } else if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINE, "Out of time respose received " + rsp.getSessionID() + from);
            }
            if (this.frontEndStatus != 0) {
                this.frontEndStatus = 0;
                this.resetTimer();
                this.waitingForFlush = HTTPBEDispatcher.access$300(HTTPBEDispatcher.this).flush();
            }
            if ((rsp.getInfo() & 64) == 0) ** GOTO lbl44
            if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINE, "Last response detected");
            }
            HTTPBEDispatcher.this.shutdown();
            return null;
lbl-1000:
            // 1 sources

            {
                try {
                    this.commandWaiter = Thread.currentThread();
                    this.wait(this.keepAliveTime);
                    this.commandWaiter = null;
                    if (!this.commandReady) {
                        if (this.connectionReset) {
                            if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINE)) {
                                HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINE, "Return with no command to deliver");
                            }
                            return null;
                        }
                        if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.ALL)) {
                            HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.ALL, "Sending keep-alive packet");
                        }
                        return new JICPPacket(2, 0, null);
                    }
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
lbl44:
                // 3 sources

                ** while (!this.commandReady)
            }
lbl45:
            // 1 sources

            if (HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).isLoggable(Logger.FINEST)) {
                HTTPBEDispatcher.access$200(HTTPBEDispatcher.this).log(Logger.FINEST, "Delivering outgoing command " + this.currentCommand.getSessionID());
            }
            this.commandReady = false;
            return this.currentCommand;
        }

        public synchronized void setConnecting() {
            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Resetting the connection");
            }
            this.initialResponseReceived = false;
            this.frontEndStatus = 1;
            this.reset();
            Thread t = new Thread(this){
                private final /* synthetic */ OutgoingsHandler this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (!OutgoingsHandler.access$100(HTTPBEDispatcher.access$000(OutgoingsHandler.access$400(this.this$1)), 60000L)) {
                        if (HTTPBEDispatcher.access$200(OutgoingsHandler.access$400(this.this$1)).isLoggable(Logger.FINE)) {
                            HTTPBEDispatcher.access$200(OutgoingsHandler.access$400(this.this$1)).log(Logger.FINE, "Missing initial dummy response after reconnection");
                        }
                        OutgoingsHandler.access$500(this.this$1);
                    }
                }
            };
            t.start();
        }

        private synchronized void setUnreachable() {
            this.frontEndStatus = 2;
            this.activateTimer(this.maxDisconnectionTime);
        }

        public synchronized void setTerminating() {
            this.frontEndStatus = 3;
            this.reset();
        }

        private void reset() {
            this.commandReady = false;
            this.responseReady = false;
            this.currentCommand = null;
            this.currentResponse = null;
            this.resetTimer();
            this.notifyAll();
        }

        private void activateTimer(long timeout) {
            long now = System.currentTimeMillis();
            this.disconnectionTimer = new Timer(now + timeout, this);
            this.disconnectionTimer = Runtime.instance().getTimerDispatcher().add(this.disconnectionTimer);
            if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.FINE)) {
                HTTPBEDispatcher.this.myLogger.log(Logger.FINE, "Disconnection timer activated.");
            }
        }

        private void resetTimer() {
            if (this.disconnectionTimer != null) {
                Runtime.instance().getTimerDispatcher().remove(this.disconnectionTimer);
                this.disconnectionTimer = null;
            }
        }

        public synchronized void doTimeOut(Timer t) {
            if (this.frontEndStatus != 0) {
                if (HTTPBEDispatcher.this.myLogger.isLoggable(Logger.WARNING)) {
                    HTTPBEDispatcher.this.myLogger.log(Logger.WARNING, "Max disconnection timeout expired.");
                }
                HTTPBEDispatcher.this.handleConnectionError();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForInitialResponse(long timeout) {
            Object object = this.initialResponseLock;
            synchronized (object) {
                if (!this.initialResponseReceived) {
                    try {
                        this.initialResponseLock.wait(timeout);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return this.initialResponseReceived;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyInitialResponseReceived() {
            Object object = this.initialResponseLock;
            synchronized (object) {
                this.initialResponseReceived = true;
                this.initialResponseLock.notifyAll();
            }
        }

        static /* synthetic */ HTTPBEDispatcher access$400(OutgoingsHandler x0) {
            return x0.HTTPBEDispatcher.this;
        }

        static /* synthetic */ void access$500(OutgoingsHandler x0) {
            x0.setUnreachable();
        }
    }
}

